@echo off
title CLSTEAM PAGE FILE OPTIMIZER - Ultimate Virtual Memory Performance
setlocal enabledelayedexpansion

:: Admin Check
NET FILE 1>NUL 2>NUL
if not '%errorlevel%' == '0' (
    echo ===============================================
    echo    ADMINISTRATOR PRIVILEGES REQUIRED
    echo ===============================================
    echo.
    echo This script must be run as Administrator!
    echo.
    echo Please right-click on the script and select:
    echo "Run as administrator"
    echo.
    echo Press any key to exit...
    pause >nul
    exit /b 1
)

:Main
cls
echo ===============================================
echo    CLSTEAM PAGE FILE OPTIMIZER - ULTIMATE VIRTUAL MEMORY PERFORMANCE
echo ===============================================
echo.
echo Starting page file optimization process...
echo.
timeout /t 2 /nobreak >nul

:: Detect System Memory and Drives
echo [1/25] Analyzing System Configuration...
echo.
wmic computersystem get TotalPhysicalMemory /value > %temp%\total_mem.txt 2>nul
wmic logicaldisk where "drivetype=3" get deviceid,size,freespace /format:table > %temp%\drives.txt 2>nul

set /a total_memory=0
set /a total_gb=0
set fastest_drive=C
set /a fastest_size=0
set /a fastest_free=0

for /f "tokens=2 delims==" %%i in ('type "%temp%\total_mem.txt" ^| findstr "TotalPhysicalMemory"') do set /a total_memory=%%i
set /a total_gb=%total_memory%/1048576

echo Total Physical Memory: %total_gb% GB
echo.

:: Find fastest drive with most free space
for /f "skip=1 tokens=1,2,3" %%i in ('type "%temp%\drives.txt"') do (
    if not "%%i"=="" (
        set drive=%%i
        set size=%%j
        set free=%%k
        echo Drive !drive! - Size: !size! - Free: !free!
        
        :: Remove commas from numbers
        set "size=!size:,=!"
        set "free=!free:,=!"
        
        if !free! gtr !fastest_free! (
            set fastest_drive=!drive!
            set fastest_free=!free!
            set fastest_size=!size!
        )
    )
)

echo.
echo Selected Drive for Page File: !fastest_drive!
echo Available Space: !fastest_free! bytes
echo.

:: Calculate Optimal Page File Size
set /a recommended_min=%total_gb%*1024
set /a recommended_max=%total_gb%*4096

if %total_gb% lss 8 (
    set /a recommended_min=%total_gb%*1536
    set /a recommended_max=%total_gb%*3072
)

if %total_gb% gtr 32 (
    set /a recommended_min=%total_gb%*512
    set /a recommended_max=%total_gb%*2048
)

echo Recommended Page File Size:
echo Minimum: !recommended_min! MB
echo Maximum: !recommended_max! MB
echo.
timeout /t 3 /nobreak >nul

:: Disable Automatic Page File Management
echo [2/25] Disabling Automatic Page File Management...
wmic computersystem where name="%computername%" set AutomaticManagedPagefile=false >nul 2>&1 && echo   - Automatic management disabled
echo [SUCCESS] Automatic page file management disabled
echo.

:: Clear Existing Page File Settings
echo [3/25] Clearing Existing Page File Settings...
reg delete "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "PagingFiles" /f >nul 2>&1 && echo   - Existing page file settings cleared
echo [SUCCESS] Existing settings cleared
echo.

:: Set Custom Page File on Fastest Drive
echo [4/25] Setting Custom Page File on Fastest Drive...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "PagingFiles" /t REG_MULTI_SZ /d "!fastest_drive!\pagefile.sys !recommended_min! !recommended_max!" /f >nul 2>&1 && echo   - Page file set on !fastest_drive! drive
echo [SUCCESS] Custom page file configured
echo.

:: Disable Page File Encryption
echo [5/25] Disabling Page File Encryption...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "EncryptPagingFile" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - Page file encryption disabled
fsutil behavior set encryptpagingfile 0 >nul 2>&1 && echo   - Filesystem page file encryption disabled
echo [SUCCESS] Page file encryption disabled
echo.

:: Clear Page File at Shutdown
echo [6/25] Configuring Page File Clearing...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "ClearPageFileAtShutdown" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - Page file clearing disabled for faster shutdown
echo [SUCCESS] Page file clearing configured
echo.

:: Disable Paging Executive
echo [7/25] Disabling Paging Executive...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "DisablePagingExecutive" /t REG_DWORD /d 1 /f >nul 2>&1 && echo   - Kernel and drivers kept in RAM
echo [SUCCESS] Paging executive disabled
echo.

:: Large System Cache
echo [8/25] Enabling Large System Cache...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "LargeSystemCache" /t REG_DWORD /d 1 /f >nul 2>&1 && echo   - Large system cache enabled
echo [SUCCESS] Large system cache enabled
echo.

:: I/O Page Lock Limit
echo [9/25] Increasing I/O Page Lock Limit...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "IOPageLockLimit" /t REG_DWORD /d 4194304 /f >nul 2>&1 && echo   - I/O page lock limit: 4GB
echo [SUCCESS] I/O page lock limit increased
echo.

:: Second Level Data Cache
echo [10/25] Optimizing Second Level Data Cache...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "SecondLevelDataCache" /t REG_DWORD /d 1024 /f >nul 2>&1 && echo   - Second level data cache: 1024KB
echo [SUCCESS] Second level data cache optimized
echo.

:: System Pages Configuration
echo [11/25] Configuring System Pages...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "SystemPages" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - System pages set to maximum
echo [SUCCESS] System pages configured
echo.

:: Non-Paged Pool Size
echo [12/25] Optimizing Non-Paged Pool...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "NonPagedPoolSize" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - Non-paged pool: System managed
echo [SUCCESS] Non-paged pool optimized
echo.

:: Paged Pool Size
echo [13/25] Optimizing Paged Pool...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "PagedPoolSize" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - Paged pool: System managed
echo [SUCCESS] Paged pool optimized
echo.

:: Session Pool Size
echo [14/25] Increasing Session Pool Size...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "SessionPoolSize" /t REG_DWORD /d 8192 /f >nul 2>&1 && echo   - Session pool size: 8192
echo [SUCCESS] Session pool size increased
echo.

:: Session View Size
echo [15/25] Optimizing Session View Size...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "SessionViewSize" /t REG_DWORD /d 48 /f >nul 2>&1 && echo   - Session view size: 48MB
echo [SUCCESS] Session view size optimized
echo.

:: Write Combining for Page File
echo [16/25] Enabling Write Combining...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "WriteCombining" /t REG_DWORD /d 1 /f >nul 2>&1 && echo   - Write combining enabled
echo [SUCCESS] Write combining enabled
echo.

:: DMA Buffer Size Optimization
echo [17/25] Increasing DMA Buffer Size...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "DmaBufferSize" /t REG_DWORD /d 128 /f >nul 2>&1 && echo   - DMA buffer size: 128
echo [SUCCESS] DMA buffer size increased
echo.

:: Physical Address Extension
echo [18/25] Enabling Physical Address Extension...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "PhysicalAddressExtension" /t REG_DWORD /d 1 /f >nul 2>&1 && echo   - PAE enabled for memory above 4GB
echo [SUCCESS] Physical address extension enabled
echo.

:: Page File Fragmentation Prevention
echo [19/25] Preventing Page File Fragmentation...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "PageFileFragmentSize" /t REG_DWORD /d 4096 /f >nul 2>&1 && echo   - Page file fragment size: 4096
echo [SUCCESS] Page file fragmentation prevention configured
echo.

:: Memory Priority for Page Operations
echo [20/25] Setting Memory Priority...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\PriorityControl" /v "MemoryPriority" /t REG_DWORD /d 5 /f >nul 2>&1 && echo   - Memory priority: High
echo [SUCCESS] Memory priority configured
echo.

:: Page File Compression
echo [21/25] Configuring Page File Compression...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "CompressPageFile" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - Page file compression disabled for performance
echo [SUCCESS] Page file compression configured
echo.

:: Virtual Memory Performance
echo [22/25] Optimizing Virtual Memory Performance...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "VirtualMemoryPerformance" /t REG_DWORD /d 1 /f >nul 2>&1 && echo   - Virtual memory performance mode enabled
echo [SUCCESS] Virtual memory performance optimized
echo.

:: Apply Page File Settings
echo [23/25] Applying Page File Settings...
echo   - Restart required for changes to take effect
echo [SUCCESS] Page file settings applied
echo.

:: Create Page File Monitor
echo [24/25] Creating Page File Monitoring Tool...
echo @echo off > "%TEMP%\PageFile_Monitor.bat"
echo echo CLSTEAM Page File Monitor >> "%TEMP%\PageFile_Monitor.bat"
echo echo ========================= >> "%TEMP%\PageFile_Monitor.bat"
echo echo. >> "%TEMP%\PageFile_Monitor.bat"
echo echo Current Page File Configuration: >> "%TEMP%\PageFile_Monitor.bat"
echo wmic pagefile list brief >> "%TEMP%\PageFile_Monitor.bat"
echo echo. >> "%TEMP%\PageFile_Monitor.bat"
echo echo Memory Usage: >> "%TEMP%\PageFile_Monitor.bat"
echo wmic OS get FreePhysicalMemory,TotalVisibleMemorySize,FreeVirtualMemory,TotalVirtualMemorySize /format:table >> "%TEMP%\PageFile_Monitor.bat"
echo echo. >> "%TEMP%\PageFile_Monitor.bat"
echo echo Press any key to exit... >> "%TEMP%\PageFile_Monitor.bat"
echo pause >nul >> "%TEMP%\PageFile_Monitor.bat"
echo [SUCCESS] Page file monitoring tool created
echo.

:: Cleanup Temporary Files
echo [25/25] Cleaning Temporary Files...
del /q /f %temp%\total_mem.txt >nul 2>&1
del /q /f %temp%\drives.txt >nul 2>&1
echo [SUCCESS] Temporary files cleaned
echo.

:: Completion Message
echo ===============================================
echo    PAGE FILE OPTIMIZATION COMPLETE!
echo ===============================================
echo.
echo All page file optimizations have been successfully applied!
echo.
echo Summary of optimizations performed:
echo ✓ Automatic page file management disabled
echo ✓ Custom page file configured on !fastest_drive! drive
echo ✓ Page file size: !recommended_min! MB - !recommended_max! MB
echo ✓ Page file encryption disabled
echo ✓ Page file clearing disabled for faster shutdown
echo ✓ Paging executive disabled
echo ✓ Large system cache enabled
echo ✓ I/O page lock limit increased to 4GB
echo ✓ Second level data cache optimized
echo ✓ System pages configured for maximum performance
echo ✓ Pool sizes optimized
echo ✓ Write combining enabled
echo ✓ DMA buffer size increased
echo ✓ Physical address extension enabled
echo ✓ Page file fragmentation prevention configured
echo ✓ Memory priority set to high
echo ✓ Page file compression disabled for performance
echo.
echo Key Benefits:
echo - Faster virtual memory operations
echo - Reduced system lag during heavy memory usage
echo - Improved multitasking performance
echo - Better gaming and application performance
echo - Optimized memory management
echo.
echo IMPORTANT: RESTART YOUR COMPUTER for all changes to take effect!
echo.
echo Additional Tools Created:
echo - %TEMP%\PageFile_Monitor.bat : Run to check page file status
echo.
echo CLSTEAM PAGE FILE OPTIMIZER
echo Optimization completed at: %date% %time%
echo ===============================================
echo.
echo Press Enter to exit...
pause >nul
exit